/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.mountainmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIEatBlock;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityYale
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal,
IShearable {
    public DropRate woolDrop;
    private final InventoryCrafting colorMixer = new InventoryCrafting(new Container(){
        private static final String __OBFID = "CL_00001649";

        public boolean func_75145_c(EntityPlayer par1EntityPlayer) {
            return false;
        }
    }, 2, 1);
    protected static final DataParameter<Byte> FUR = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityYale(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.experience = 3;
        this.hasAttackSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setWidth = 0.9f;
        this.setHeight = 1.8f;
        this.fleeHealthPercent = 1.0f;
        this.isHostileByDefault = false;
        this.setupMob();
        this.colorMixer.func_70299_a(0, new ItemStack(Items.field_151100_aR, 1, 0));
        this.colorMixer.func_70299_a(1, new ItemStack(Items.field_151100_aR, 1, 0));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItemList("vegetables"));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIEatBlock(this).setBlocks(new Block[]{Blocks.field_150349_c}).setReplaceBlock(Blocks.field_150346_d));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUR, (Object)1);
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("YaleMeatRaw")), 1.0f).setMinAmount(1).setMaxAmount(3));
        if (this.woolDrop == null) {
            this.woolDrop = new DropRate(new ItemStack(Blocks.field_150325_L), 1.0f).setMinAmount(1).setMaxAmount(3);
        }
        this.drops.add(this.woolDrop);
    }

    @Override
    public void onFirstSpawn() {
        if (!this.func_70631_g_()) {
            this.setColor(this.getRandomFurColor(this.func_70681_au()));
        }
        super.onFirstSpawn();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.hasFur() && !this.func_70631_g_();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setFur(false);
        this.func_184185_a(new SoundEvent(new ResourceLocation("mob.sheep.shear")), 1.0f, 1.0f);
        ArrayList<ItemStack> dropStacks = new ArrayList<ItemStack>();
        int quantity = this.woolDrop.getQuantity(this.func_70681_au(), fortune);
        ItemStack dropStack = this.woolDrop.getItemStack((EntityLivingBase)this, quantity);
        this.dropItem(dropStack);
        dropStacks.add(dropStack);
        return dropStacks;
    }

    public boolean hasFur() {
        if (this.field_70180_af == null) {
            return true;
        }
        return (Byte)this.field_70180_af.func_187225_a(FUR) > 0;
    }

    public void setFur(boolean fur) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(FUR, (Object)((byte)(fur ? 1 : 0)));
        }
    }

    @Override
    public void onEat() {
        if (!this.func_130014_f_().field_72995_K) {
            this.setFur(true);
        }
    }

    @Override
    public boolean canBeColored(EntityPlayer player) {
        return true;
    }

    @Override
    public void setColor(int color) {
        if (this.woolDrop == null) {
            this.woolDrop = new DropRate(new ItemStack(Blocks.field_150325_L), 1.0f).setMinAmount(1).setMaxAmount(3);
        }
        this.woolDrop.setDrop(new ItemStack(Blocks.field_150325_L, 1, color));
        super.setColor(color);
    }

    public int getRandomFurColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? 15 : (i < 10 ? 7 : (i < 15 ? 8 : (i < 18 ? 12 : (random.nextInt(500) == 0 ? 6 : 0))));
    }

    public int getMixedFurColor(EntityCreatureBase entityA, EntityCreatureBase entityB) {
        int j;
        int i = 15 - entityA.getColor();
        if (i == (j = 15 - entityB.getColor())) {
            return 15 - i;
        }
        this.colorMixer.func_70301_a(0).func_77964_b(i);
        this.colorMixer.func_70301_a(1).func_77964_b(j);
        ItemStack itemstack = CraftingManager.func_77594_a().func_82787_a(this.colorMixer, this.func_130014_f_());
        int k = itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR ? itemstack.func_77952_i() : (this.func_130014_f_().field_73012_v.nextBoolean() ? i : j);
        return 15 - k;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        if (ObjectManager.getPotionEffect("weight") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("weight")) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    protected void func_70628_a(boolean playerKill, int lootLevel) {
        if (!this.hasFur()) {
            this.woolDrop.setMinAmount(0).setMaxAmount(0);
        }
        super.func_70628_a(playerKill, lootLevel);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partner) {
        EntityYale baby = new EntityYale(this.func_130014_f_());
        int color = this.getMixedFurColor(this, partner);
        ((EntityCreatureBase)baby).setColor(color);
        return baby;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("vegetables", testStack);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("HasFur")) {
            this.setFur(nbtTagCompound.func_74767_n("HasFur"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("HasFur", this.hasFur());
    }
}

